/*
 * Copyright European Commission's
 * Taxation and Customs Union Directorate-General (DG TAXUD).
 */
package eu.europa.ec.taxud.cesop.domain;

/**
 * Enum for transaction dates.
 */
public enum TransactionDateEnum {

    /**
     * Execution date transaction date.
     */
    EXECUTION_DATE("CESOP701"),
    /**
     * Clearing date transaction date.
     */
    CLEARING_DATE("CESOP702"),
    /**
     * Authorisation date transaction date.
     */
    AUTHORISATION_DATE("CESOP703"),
    /**
     * Purchase date transaction date.
     */
    PURCHASE_DATE("CESOP704"),
    /**
     * Settlement date transaction date.
     */
    SETTLEMENT_DATE("CESOP705"),
    /**
     * Other date transaction date.
     */
    OTHER_DATE("CESOP709");

    private final String label;

    TransactionDateEnum(final String label) {
        this.label = label;
    }

    /**
     * Gets label.
     *
     * @return the label
     */
    public String getLabel() {
        return this.label;
    }

    /**
     * Find a {@link TransactionDateEnum} by its label.
     *
     * @param label the label
     * @return the TransactionDateEnum
     * @throws IllegalArgumentException if there is no value for the label
     */
    public static TransactionDateEnum findByLabel(final String label) {
        for (final TransactionDateEnum value : values()) {
            if (value.getLabel().equals(label)) {
                return value;
            }
        }
        throw new IllegalArgumentException("No TransactionDateEnum found for label: " + label);
    }
}
